<?php

/* Template Name: Service Listing */

get_header();

?>
<section class="service-listing__masthead">
    <?php render_masthead('servcie_listing_masthead', array(
        'masthead_button' => array(
                'url' => '#service-listing',
                'title' => 'Read more',
            'target' => '_self'
        )
    )); ?>
</section>

<?php
$args = [
    'post_type' => 'service',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'orderby' => 'menu_order',
    'order' => 'ASC',
    'post_parent' => 0
];

$posts_query = new WP_Query($args);

?>

    <section id="service-listing" class="service-listing">
        <?php include(get_template_directory() . '/inc/partials/breadcrumb.php'); ?>
        <div class="service-listing__grid">
            <div class="container">
                <div class="row">
                    <?php if ($posts_query->have_posts()) {
                        while ($posts_query->have_posts()) : $posts_query->the_post();
                            $service = $post; ?>
                            <div class="col-12 col-sm-6 col-md-4 service-listing__item">
                                <?php include(get_template_directory() . '/inc/partials/service-card.php'); ?>
                            </div>
                            <?php unset($service);
                        endwhile;
                    } else { ?>
                        <div class="col-12">
                            <h3>No services to show</h3>
                        </div>
                    <?php } ?>
                </div>
            </div>
    </section>

<?php

include(get_template_directory() . '/inc/blocks/featured-footer.php');

get_footer();
