<?php

/* Template Name: Project Listing */

get_header();

render_masthead('project_listing_masthead');

// Active Filters
$filtered_services = get_query_var('services');
$filtered_sectors = get_query_var('sectors');
$filtered_services_arr = array();
$filtered_sectors_arr = array();
$meta_query = array(
    'relation' => 'OR'
);

if($filtered_services != '') {
    $filtered_services_arr = explode(',', $filtered_services);

    foreach ($filtered_services_arr as $service_id) {
        array_push($meta_query, array(
            'key' => 'related_services',
            'value' => '"' . $service_id . '"',
            'compare' => 'LIKE'
        ));
    }
}

if($filtered_sectors != '') {
    $filtered_sectors_arr = explode(',', $filtered_sectors);

    foreach ($filtered_sectors_arr as $sector_id) {
        array_push($meta_query, array(
            'key' => 'related_sectors',
            'value' => '"' . $sector_id . '"',
            'compare' => 'LIKE'
        ));
    }
}

// Projects
$args = array(
    'numberposts' => -1,
    'post_type' => 'project',
    'post_status' => 'publish',
    'orderby' => 'menu_order',
    'order' => 'ASC',
    'meta_query' => $meta_query
);

$projects = get_posts($args);

include(get_template_directory() . '/inc/partials/filters.php');

?>

    <section class="project-listing">
        <div class="container">
            <div class="project-listing__grid">
                <div class="row">
                    <?php if ($projects != null && !empty($projects)) {
                        foreach ($projects as $project) {
                            $thumb = get_the_post_thumbnail_url($project->ID, 'project-listing');
                            $excerpt = get_the_excerpt($project->ID);
                            $sectors = get_field('related_sectors', $project->ID);
                            ?>
                            <div class="col-12 col-md-6 col-lg-4 project-listing__grid__item">
                                <a href="<?php echo get_the_permalink($project->ID); ?>"
                                   title="<?php echo $project->post_title; ?>"
                                   class="project-card d-flex flex-column">
                                    <div class="project-card__image"
                                         style="background-image: url(<?php echo($thumb != '' ? $thumb : ''); ?>);">

                                        <?php if ($sectors != null) { ?>
                                            <div class="project-card__sector">
                                                <?php foreach ($sectors as $sector) { ?>
                                                    <span class="m-0 small-title color-white"><?php echo $sector->post_title; ?></span>
                                                <?php } ?>
                                            </div>
                                        <?php } ?>
                                    </div>

                                    <div class="project-card__content d-flex flex-grow-1 flex-column">

                                        <h3 class="m-0"><?php echo $project->post_title; ?></h3>

                                        <?php if ($excerpt != '') { ?>
                                            <div class="project-card__excerpt text-block">
                                                <p><?php echo $excerpt; ?></p>
                                            </div>
                                        <?php } ?>

                                        <div class="arrow-link project-card__arrow-link">
                                            Read more
                                            <span class="arrow-link__arrow"><i class="far fa-arrow-right"
                                                                               aria-hidden="true"></i></span>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        <?php }
                    } else { ?>
                        <div class="col-12">
                            <h3>No projects to show</h3>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>

<?php

include(get_template_directory() . '/inc/blocks/contact-cta.php');
include(get_template_directory() . '/inc/blocks/featured-footer.php');

get_footer();