<?php

/* Template Name: About */

get_header();

render_masthead('about_masthead');
include(get_template_directory() . '/inc/partials/breadcrumb.php');

?>

<?php
$content_title = get_field('content_title');
$content_subtitle = get_field('content_subtitle');
$content_content = get_field('content_content');
$content_page_link = get_field('content_page_link');
$content_page_link_image = get_field('content_page_link_image');
$content_blocks = get_field('content_blocks');

?>

    <section class="about__intro">
        <div class="container">
            <div class="row large-gutters">
                <div class="col-12 col-md-6 col-lg-4">
                    <?php if ($content_title != '') { ?>
                        <h2 class="about__intro__title"><?php echo $content_title; ?></h2>
                    <?php } ?>

                    <?php if ($content_subtitle != '') { ?>
                        <div class="about__intro__opening-text">
                            <div class="text-block">
                                <?php echo $content_subtitle; ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>

                <div class="col-12 col-md-6 col-lg-4">
                    <div class="text-block">
                        <?php echo $content_content; ?>
                    </div>
                </div>

                <?php if ($content_page_link != null) { ?>
                    <div class="col-12 col-lg-4">
                        <a href="<?php echo $content_page_link['url']; ?>"
                           title="<?php echo $content_page_link['title']; ?>"
                           class="about__intro__page-link"
                           style="background-image: url(<?php echo($content_page_link_image != null ? $content_page_link_image['url'] : '') ?>);">
                            <div class="about__intro__page-link__content">
                                <div class="row small-gutters">
                                    <div class="col-7 align-self-end">
                                        <?php echo $content_page_link['title']; ?>
                                    </div>

                                    <div class="col-5 text-right">
                                        <span class="btn btn-primary about__intro__page-link__btn">
                                            Visit <span class="btn__arrow"><i class="far fa-arrow-right"></i></span>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php } ?>
            </div>
        </div>
    </section>

<?php if ($content_blocks != null && !empty($content_blocks)) {
    $block_count = 0;
    foreach ($content_blocks as $block) { ?>
        <section class="about__content-block">
            <div class="container">
                <div class="row large-gutters">
                    <div class="col-12 col-md-6 align-self-center <?php echo ($block_count % 2 ? 'order-md-12' : ''); ?>">
                        <?php if ($block['title'] != '') { ?>
                            <h2><?php echo $block['title']; ?></h2>
                        <?php } ?>

                        <?php if ($block['content'] != '') { ?>
                            <div class="text-block">
                                <?php echo $block['content']; ?>
                            </div>
                        <?php } ?>
                    </div>

                    <div class="col-12 col-md-6 <?php echo ($block_count % 2 ? 'order-md-1' : ''); ?>">
                        <?php if($block['image'] != null) { ?>
                                <div class="about__content-block__image">
                                    <img src="<?php echo $block['image']['sizes']['content-image']; ?>"
                                         alt="<?php echo $block['image']['alt']; ?>"
                                         class="img-fluid"/>
                                </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </section>
    <?php $block_count++;
    }
} ?>

<div class="about__divider">
    <div class="container">
        <div class="about__divider__line"></div>
    </div>
</div>

<?php

include(get_template_directory() . '/inc/blocks/career-listing.php');
include(get_template_directory() . '/inc/blocks/contact-cta.php');
include(get_template_directory() . '/inc/blocks/featured-footer.php');

get_footer();
