<?php

get_header();

$opening_image = get_field('opening_image');
$next_post = get_next_post();

?>

    <section
            class="news-article-masthead <?php echo($opening_image != null ? 'news-article-masthead--bottom-spacing' : ''); ?>">
        <div class="news-article-masthead__content">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-12 col-lg-9 col-xl-8 text-center">
                        <p class="m-0 color-white small-title">
                            <?php echo get_the_date('d.m.y'); ?>
                        </p>

                        <h1 class="news-article-masthead__title">
                            <?php echo get_the_title(); ?></h1>

                        <?php include(get_template_directory() . '/inc/partials/breadcrumb.php'); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="news-article">
        <div class="container">
            <div class="news-article__content-wrapper">
                <?php if ($opening_image != null) { ?>
                    <div class="news-article__opening-image">
                        <div class="row justify-content-center">
                            <div class="col-12 col-lg-10">
                                <img src="<?php echo $opening_image['url']; ?>"
                                     alt="<?php echo $opening_image['alt']; ?>"
                                     class="img-fluid"/>
                            </div>
                        </div>
                    </div>
                <?php } ?>

                <div class="news-article__content">
                    <div class="row justify-content-center">
                        <div class="col-12 col-lg-9 col-xl-8">
                            <?php render_content_blocks('news_article_content'); ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="news-article__footer">
                <div class="row justify-content-center">
                    <div class="col-12 col-lg-9 col-xl-8">
                        <div class="row large-gutters">
                            <div class="col-12 col-md-auto">
                                <h4 class="small-title small-title--accented m-0">Share this article</h4>
                                <div class="news-article__social-links__wrapper">
                                    <?php include(get_template_directory() . '/inc/partials/social-sharing-icons.php'); ?>
                                </div>
                            </div>

                            <div class="col-12 col-md">
                                <?php if ($next_post != null) { ?>
                                    <a href="<?php echo get_the_permalink($next_post->ID); ?>"
                                       title="<?php echo $next_post->post_title; ?>"
                                       class="career-link">
                                        <div class="row no-gutters">
                                            <div class="col">
                                                <div class="career-link__title">
                                                    <p class="small-title m-0"><span class="news-article__next-link__subtitle">Next post</span> <?php echo get_the_date('d.m.y', $next_post->ID); ?></p>
                                                    <p class="m-0 news-article__next-link__title"><?php echo $next_post->post_title; ?></p>
                                                </div>
                                            </div>

                                            <div class="col-auto">
                                        <span class="career-link__arrow d-flex flex-column justify-content-center">
                                            <i class="far fa-chevron-right"></i>
                                        </span>
                                            </div>
                                        </div>
                                    </a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php

include(get_template_directory() . '/inc/blocks/contact-cta.php');
include(get_template_directory() . '/inc/blocks/featured-footer.php');

get_footer();
