<?php

get_header();

$masthead_subtitle = get_field('sector_masthead_masthead_subtitle');
if ($masthead_subtitle == '') {
    $masthead_subtitle = 'Sector';
}

render_masthead('sector_masthead', array(
    'show_overlay' => false,
    'masthead_subtitle' => $masthead_subtitle
));

// Content
$intro_title = get_field('intro_content_title');
$intro_content = get_field('intro_content');
$intro_btn = get_field('intro_content_button');

// Top & Bottom Content
$top_title = get_field('top_content_title');
$top_content = get_field('top_content');
$top_image = get_field('top_content_image');

$bottom_title = get_field('bottom_content_title');
$bottom_content = get_field('bottom_content');
$bottom_image = get_field('bottom_content_image');

// Related Projects
$args = array(
    'numberposts' => -1,
    'post_type' => 'project',
    'post_status' => 'publish',
    'orderby' => 'menu_order',
    'order' => 'ASC',
    'meta_query' => array(
        array(
            'key' => 'related_sectors',
            'value' => '"' . get_the_ID() . '"',
            'compare' => 'LIKE'
        )
    )
);

$related_projects = get_posts($args);

?>

    <section class="sector">
        <section class="sector__intro">
            <?php include(get_template_directory() . '/inc/partials/breadcrumb.php'); ?>

            <div class="sector__intro__inner">
                <div class="container">
                    <?php if ($intro_title != '') { ?>
                        <h2 class="small-title">
                            <span class="sector__intro__inner__title-icon"><i class="far fa-briefcase"></i></span>
                            <?php echo $intro_title; ?>
                        </h2>
                    <?php } ?>

                    <?php if ($intro_content != '') { ?>
                        <div class="row">
                            <div class="col-12 col-lg-10">
                                <div class="text-block">
                                    <?php echo $intro_content; ?>
                                </div>
                            </div>
                        </div>
                    <?php } ?>

                    <?php if ($intro_btn != null) { ?>
                        <div class="sector__intro__inner__btn text-right">
                            <?php echo format_button($intro_btn, "btn-primary", true); ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </section>
    </section>

<?php if ($top_title != '' || $top_content != '' || $top_image != null) { ?>
    <section class="sector__content-block">
        <div class="container">
            <div class="row large-gutters">
                <div class="col-12 col-md-6 align-self-center">
                    <?php if ($top_title != '') { ?>
                        <h2><?php echo $top_title; ?></h2>
                    <?php } ?>

                    <?php if ($top_content != '') { ?>
                        <div class="text-block">
                            <?php echo $top_content; ?>
                        </div>
                    <?php } ?>
                </div>

                <div class="col-12 col-md-6">
                    <?php if ($top_image != null) { ?>
                        <div class="sector__content-block__image">
                            <img src="<?php echo $top_image['sizes']['content-image']; ?>"
                                 alt="<?php echo $top_image['alt']; ?>"
                                 class="img-fluid"/>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
<?php } ?>

<?php if ($related_projects != null && !empty($related_projects)) { ?>
    <section class="sector__gallery">
        <div class="container">
            <h2 class="sector__gallery__title">Work we have provided in this sector</h2>

            <div class="js-sector-gallery">
                <?php foreach ($related_projects as $project) {
                    $thumb = get_the_post_thumbnail_url($project->ID);
                    if($thumb != '') { ?>
                        <div class="sector__gallery__slide">
                            <a href="<?php echo get_the_permalink($project->ID); ?>"
                               title="<?php echo $project->post_title; ?>">
                                <img src="<?php echo $thumb; ?>"
                                     alt="<?php echo $project->post_title; ?>"/>
                            </a>
                        </div>
                <?php }
                } ?>
            </div>

            <div class="sector__gallery__nav js-sector-gallery-dots-nav"></div>
            <div class="sector__gallery__arrow-nav js-sector-gallery-arrow-nav"></div>
        </div>
    </section>
<?php } ?>

<?php if ($bottom_title != '' || $bottom_content != '' || $bottom_image != null) { ?>
    <section class="sector__content-block sector__content-block--bottom">
        <div class="container">
            <div class="row large-gutters">
                <div class="col-12 col-md-6 align-self-center">
                    <?php if ($bottom_title != '') { ?>
                        <h2><?php echo $bottom_title; ?></h2>
                    <?php } ?>

                    <?php if ($bottom_content != '') { ?>
                        <div class="text-block">
                            <?php echo $bottom_content; ?>
                        </div>
                    <?php } ?>
                </div>

                <div class="col-12 col-md-6">
                    <?php if ($bottom_image != null) { ?>
                        <div class="sector__content-block__image">
                            <img src="<?php echo $bottom_image['sizes']['content-image']; ?>"
                                 alt="<?php echo $bottom_image['alt']; ?>"
                                 class="img-fluid"/>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
<?php } ?>

<?php

include(get_template_directory() . '/inc/blocks/contact-cta.php');
include(get_template_directory() . '/inc/blocks/featured-footer.php');

get_footer();