<?php

// Active Filters
$filtered_services = get_query_var('services');
$filtered_sectors = get_query_var('sectors');
$filtered_services_arr = array();
$filtered_sectors_arr = array();
$meta_query = array(
    'relation' => 'OR'
);
$filtered = false;

if($filtered_services != '') {
    $filtered_services_arr = explode(',', $filtered_services);

    foreach ($filtered_services_arr as $service_id) {
        array_push($meta_query, array(
            'key' => 'related_services',
            'value' => '"' . $service_id . '"',
            'compare' => 'LIKE'
        ));
    }

    $filtered = true;
}

if($filtered_sectors != '') {
    $filtered_sectors_arr = explode(',', $filtered_sectors);

    foreach ($filtered_sectors_arr as $sector_id) {
        array_push($meta_query, array(
            'key' => 'related_sectors',
            'value' => '"' . $sector_id . '"',
            'compare' => 'LIKE'
        ));
    }

    $filtered = true;
}

// Articles
$latest_post_args = array(
    'numberposts' => 1,
    'post_type' => 'post',
    'post_status' => 'publish'
);

$latest_post = get_posts($latest_post_args);

if($filtered == false) {
    $recent_post_args = array(
        'numberposts' => 4,
        'post_type' => 'post',
        'post_status' => 'publish',
        'offset' => 1
    );

    $recent_posts = get_posts($recent_post_args);
} else {
    $recent_posts = array();
}

$to_exclude = array();
$used_posts = array_merge($latest_post, $recent_posts);
if ($used_posts != null && !empty($used_posts)) {
    $to_exclude = array_column($used_posts, 'ID');
}

$args = array(
    'numberposts' => -1,
    'post_type' => 'post',
    'post_status' => 'publish',
    'offset' => 1,
    'post__not_in' => $to_exclude
);

if($filtered == true) {
    $args['post__not_in'] = array();
    $args['meta_query'] = $meta_query;
}

$articles = get_posts($args);

get_header();

?>

    <section class="news-listing-masthead">
        <div class="news-listing-masthead__content">
            <?php if ($latest_post != null) {
                $thumb = get_the_post_thumbnail_url($latest_post[0]->ID, 'content-image');
                ?>
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-12 col-lg-10">
                            <a href="<?php echo get_the_permalink($latest_post[0]->ID); ?>"
                               title="<?php echo $latest_post[0]->post_title; ?>"
                               class="news-listing-masthead__article">
                                <div class="row medium-gutters">
                                    <div class="col-12 col-md-6">
                                        <?php if ($thumb != '') { ?>
                                            <div class="news-listing-masthead__article__image">
                                                <img src="<?php echo $thumb; ?>"
                                                     alt="<?php echo $latest_post[0]->post_title; ?>"
                                                     class="img-fluid"/>
                                            </div>
                                        <?php } ?>
                                    </div>

                                    <div class="col-12 col-md-6 align-self-center">
                                        <p class="small-title color-white"><span
                                                    class="news-listing-masthead__article__subtitle">Latest Article</span> <?php echo get_the_date('d.m.y', $latest_post[0]->ID); ?>
                                        </p>
                                        <h1 class="m-0"><?php echo $latest_post[0]->post_title; ?></h1>
                                        <div class="btn btn-primary news-listing-masthead__article__btn">
                                            Read More <span class="btn__arrow"><i class="far fa-arrow-right"></i></span>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>
    </section>

    <?php include(get_template_directory() . '/inc/partials/filters.php'); ?>

    <?php if($filtered == false) { ?>
        <section class="news-listing__latest">
            <div class="container">
                <h2 class="small-title small-title--accented">Latest</h2>

                <div class="news-listing__latest__grid">
                    <div class="row">
                        <?php foreach ($recent_posts as $article) {
                            $thumb = get_the_post_thumbnail_url($article->ID, 'news-listing');
                            ?>
                            <div class="col-12 col-sm-6 col-lg-3">
                                <a href="<?php echo get_the_permalink($article->ID); ?>"
                                   title="<?php echo $article->post_title; ?>"
                                   class="news-listing__article news-listing__article">
                                    <?php if ($thumb != '') { ?>
                                        <div class="news-listing__article__image">
                                            <img src="<?php echo $thumb; ?>"
                                                 alt="<?php echo $article->post_title; ?>"
                                                 class="img-fluid"/>
                                        </div>
                                    <?php } ?>
                                    <h3 class="news-listing__article__title"><?php echo $article->post_title; ?></h3>
                                    <p class="small-title"><?php echo get_the_date('d.m.y', $article->ID); ?></p>
                                    <div class="btn btn-white news-listing__article__btn">Read more <span
                                                class="btn__arrow"><i
                                                    class="far fa-arrow-right"></i></span></div>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </section>
    <?php } ?>

    <section class="news-listing__main">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12 col-lg-10 col-xl-9">

                    <h2 class="small-title small-title--accented">All articles</h2>

                    <div class="news-listing__main__grid">
                        <div class="row">
                            <?php foreach ($articles as $article) {
                                $thumb = get_the_post_thumbnail_url($article->ID, 'news-listing');
                                $excerpt = get_the_excerpt($article->ID);
                                ?>
                                <div class="col-12">
                                    <a href="<?php echo get_the_permalink($article->ID); ?>"
                                       title="<?php echo $article->post_title; ?>"
                                       class="news-listing__article news-listing__article--full-width">
                                        <div class="row">
                                            <div class="col-12 col-md-4">
                                                <?php if ($thumb != '') { ?>
                                                    <div class="news-listing__article__image mb-md-0">
                                                        <img src="<?php echo $thumb; ?>"
                                                             alt="<?php echo $article->post_title; ?>"
                                                             class="img-fluid"/>
                                                    </div>
                                                <?php } ?>
                                            </div>

                                            <div class="col-12 col-md-8">
                                                <p class="small-title"><?php echo get_the_date('d.m.y', $article->ID); ?></p>
                                                <h3 class="news-listing__article__title news-listing__article__title--large"><?php echo $article->post_title; ?></h3>

                                                <?php if ($excerpt != '') { ?>
                                                    <div class="text-block d-none d-md-block">
                                                        <p><?php echo $excerpt; ?></p>
                                                    </div>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php

include(get_template_directory() . '/inc/blocks/contact-cta.php');
include(get_template_directory() . '/inc/blocks/featured-footer.php');

get_footer();