<?php

// Register Custom Post Type
function sector_register_post_type() {
    $labels = array(
        'name'                  => 'Sectors',
        'singular_name'         => 'Sector',
        'menu_name'             => 'Sectors',
        'name_admin_bar'        => 'Sector',
        'archives'              => 'Sector Archives',
        'attributes'            => 'Sector Attributes',
        'parent_item_colon'     => 'Parent Sector:',
        'all_items'             => 'All Sectors',
        'add_new_item'          => 'Add New Sector',
        'add_new'               => 'Add New',
        'new_item'              => 'New Sector',
        'edit_item'             => 'Edit Sector',
        'update_item'           => 'Update Sector',
        'view_item'             => 'View Sector',
        'view_items'            => 'View Sectors',
        'search_items'          => 'Search Sectors',
        'not_found'             => 'Not found',
        'not_found_in_trash'    => 'Not found in Trash',
        'featured_image'        => 'Featured Image',
        'set_featured_image'    => 'Set featured image',
        'remove_featured_image' => 'Remove featured image',
        'use_featured_image'    => 'Use as featured image',
    );

    $args = array(
        'label'                 => 'Sector',
        'labels'                => $labels,
        'supports'              => array( 'title', 'thumbnail', 'page-attributes', 'excerpt' ),
        'rewrite'               => array('slug' => 'sectors', 'with_front' => false),
        'hierarchical'          => true,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 24,
        'menu_icon'             => 'dashicons-building',
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => false,
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'page',
    );
    register_post_type( 'sector', $args );
}
add_action( 'init', 'sector_register_post_type', 0 );