<?php

// Register Custom Post Type
function career_register_post_type() {
    $labels = array(
        'name'                  => 'Careers',
        'singular_name'         => 'Career',
        'menu_name'             => 'Careers',
        'name_admin_bar'        => 'Career',
        'archives'              => 'Career Archives',
        'attributes'            => 'Career Attributes',
        'parent_item_colon'     => 'Parent Career:',
        'all_items'             => 'All Careers',
        'add_new_item'          => 'Add New Career',
        'add_new'               => 'Add New',
        'new_item'              => 'New Career',
        'edit_item'             => 'Edit Career',
        'update_item'           => 'Update Career',
        'view_item'             => 'View Career',
        'view_items'            => 'View Careers',
        'search_items'          => 'Search Careers',
        'not_found'             => 'Not found',
        'not_found_in_trash'    => 'Not found in Trash',
        'featured_image'        => 'Featured Image',
        'set_featured_image'    => 'Set featured image',
        'remove_featured_image' => 'Remove featured image',
        'use_featured_image'    => 'Use as featured image',
    );

    $args = array(
        'label'                 => 'Career',
        'labels'                => $labels,
        'supports'              => array( 'title', 'page-attributes'),
        'rewrite'               => array('slug' => 'careers', 'with_front' => false),
        'hierarchical'          => true,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 24,
        'menu_icon'             => 'dashicons-businessman',
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => false,
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'page',
    );
    register_post_type( 'career', $args );
}
add_action( 'init', 'career_register_post_type', 0 );