<?php

$bg = null;
$thumbnail = get_the_post_thumbnail_url(get_the_ID(), 'full');
if ($thumbnail != '') {
    $bg['url'] = $thumbnail;
}

render_masthead('service_masthead', array(
    'masthead_subtitle' => 'Services for',
    'masthead_background_image' => $bg
));

// Content
$title = get_field('content_box_title');
$content = get_field('content_box_content');
$image = get_field('content_box_image');

$child_services = get_children(array(
    'post_parent' => get_the_ID(),
    'post_type' => 'service'));

?>

    <section class="service">
        <div class="service__child-listing">
            <?php include(get_template_directory() . '/inc/partials/breadcrumb.php'); ?>

            <div class="page-content-wrapper">
                <div class="container">
                    <?php if ($title != '' || $content != '' || $image != null) { ?>
                        <section class="service__child-listing__content-box">
                            <div class="row no-gutters">
                                <div class="col-12 col-md-6 col-lg-8 order-md-12">
                                    <div class="service__child-listing__content-box__image"
                                         style="background-image:url(<?php echo ($image != null ? $image['url'] : ''); ?>);"></div>
                                </div>

                                <div class="col-12 col-md-6 col-lg-4 order-md-1">
                                    <div class="service__child-listing__content-box__content">
                                        <h3 class="service__child-listing__content-box__title small-title small-title--accented">
                                            <?php echo get_the_title(); ?>
                                        </h3>

                                        <?php if ($title != '') { ?>
                                            <h2 class="service__child-listing__content-box__title">
                                                <?php echo $title; ?></h2>
                                        <?php } ?>

                                        <?php if ($content != '') { ?>
                                            <div class="text-block">
                                                <?php echo $content; ?>
                                            </div>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                        </section>
                    <?php } ?>

                    <section class="service__child-listing__grid">
                        <h2 class="service__child-listing__grid__title">
                            <?php echo get_the_title() . ' Services'; ?></h2>

                        <div class="row">
                            <?php foreach ($child_services as $service) { ?>
                                <div class="col-12 col-sm-6 col-md-4 service-listing__item">
                                    <?php include(get_template_directory() . '/inc/partials/service-card.php'); ?>
                                </div>
                            <?php } ?>
                        </div>
                    </section>
                </div>
            </div>
        </div>
    </section>

<?php

include(get_template_directory() . '/inc/blocks/contact-cta.php');
include(get_template_directory() . '/inc/blocks/featured-footer.php');

?>