<?php
// Filters
$service_args = [
    'post_type' => 'service',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'orderby' => 'post_title',
    'order' => 'ASC',
    'post_parent' => 0
];

$services = get_posts($service_args);

$sector_args = [
    'post_type' => 'sector',
    'post_status' => 'publish',
    'posts_per_page' => -1,
    'orderby' => 'post_title',
    'order' => 'ASC'
];

$sectors = get_posts($sector_args);
?>

<section class="filters">
    <div class="container">
        <div class="row">
            <div class="col-12 col-md-6 col-lg-4 col-xl-3">
                <div class="dropdown">
                    <button class="filters__dropdown-trigger"
                            type="button"
                            id="dropdownMenuButton"
                            data-toggle="dropdown"
                            aria-haspopup="true"
                            aria-expanded="false">
                        Filter by section or service
                    </button>
                    <div class="dropdown-menu filters__dropdown" aria-labelledby="dropdownMenuButton">
                        <form class="js-filter-form" data-listing-url="<?php echo (is_home() ? get_news_page_url() : get_listing_page_url('project')); ?>">
                            <?php if ($sectors != null && !empty($sectors)) { ?>
                                <div class="filters__dropdown__section">
                                    <h5 class="small-title color-white m-0">Sectors</h5>

                                    <ul class="filters__dropdown__list list-unstyled">
                                        <?php foreach ($sectors as $filter) { ?>
                                            <li class="filters__dropdown__list__item">
                                                <div class="custom-checkbox">
                                                    <input type="checkbox"
                                                           class="js-filter js-sector-filter"
                                                           name="<?php echo $filter->post_name . '-' . $filter->ID; ?>"
                                                           id="<?php echo $filter->post_name . '-' . $filter->ID; ?>"
                                                           value="<?php echo $filter->ID; ?>" <?php echo (in_array($filter->ID, $filtered_sectors_arr) ? 'checked' : ''); ?>/>
                                                    <label for="<?php echo $filter->post_name . '-' . $filter->ID; ?>"><?php echo $filter->post_title; ?></label>
                                                </div>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </div>
                            <?php } ?>

                            <?php if ($services != null && !empty($services)) { ?>
                                <div class="filters__dropdown__section">
                                    <h5 class="small-title color-white m-0">Services</h5>

                                    <ul class="filters__dropdown__list list-unstyled">
                                        <?php foreach ($services as $filter) { ?>
                                            <li class="filters__dropdown__list__item">
                                                <div class="custom-checkbox">
                                                    <input type="checkbox"
                                                           class="js-filter js-service-filter"
                                                           name="<?php echo $filter->post_name . '-' . $filter->ID; ?>"
                                                           id="<?php echo $filter->post_name . '-' . $filter->ID; ?>"
                                                           value="<?php echo $filter->ID; ?>" <?php echo (in_array($filter->ID, $filtered_services_arr) ? 'checked' : ''); ?>/>
                                                    <label for="<?php echo $filter->post_name . '-' . $filter->ID; ?>"><?php echo $filter->post_title; ?></label>
                                                </div>
                                            </li>
                                        <?php } ?>
                                    </ul>
                                </div>
                            <?php } ?>

                            <a href="#" class="filters__dropdown__btn small-title color-white js-filter-reset">Reset filters</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>