<?php
$post_type = get_post_type($featured->ID);
$thumb = get_the_post_thumbnail_url($featured->ID, 'medium');
$services = get_field('related_services', $featured->ID);

?>

<a href="<?php echo get_the_permalink($featured->ID); ?>" class="feature-card-small">
    <div class="row no-gutters">
        <?php if ($thumb != '') { ?>
            <div class="col-2">
                <div class="feature-card-small__image"
                     style="background-image: url(<?php echo $thumb; ?>)"></div>
            </div>
        <?php } ?>

        <div class="col">
            <div class="feature-card-small__content-wrapper">
                <h4 class="m-0"><?php echo get_the_title($featured->ID); ?></h4>
                <?php if($services != null && !empty($services)) {
                    $service_titles = array_column($services, 'post_title');
                    ?>
                    <p class="feature-card-small__category small-title"><?php echo implode(", ", $service_titles); ?></p>
                <?php } ?>
            </div>
        </div>

        <div class="col-4 align-self-center text-right">
            <div class="feature-card-small__btn-wrapper">
                <div class="btn btn-white btn-white--color-primary">
                    <?php echo($post_type == 'project' ? 'View project' : 'Read more'); ?>
                    <span class="btn__arrow">
                    <i class="far fa-arrow-right" aria-hidden="true"></i>
                </span>
                </div>
            </div>
        </div>
    </div>
</a>
