<?php

$bg = $data['masthead_background_image'];
$title = $data['masthead_title'];
$subtitle = $data['masthead_subtitle'];
$content = $data['masthead_content'];
$btn = $data['masthead_button'];
$size = $data['masthead_size'];
$show_breadcrumb = $data['show_breadcrumb'];
$show_overlay = $data['show_overlay'];
$project_masthead = false;

if(is_singular('project')) {
    $project_masthead = true;
}

?>

<section class="masthead <?php echo ($project_masthead ? 'masthead--project ' : ''); ?>">
    <div class="masthead__bg <?php echo ($size == 'large' ? 'masthead__bg--large ' : ''); echo($show_overlay ? 'masthead__bg--overlay' : '') ?>" style="background-image: url(<?php echo ($bg != null ? $bg['url'] : ''); ?>)"></div>

    <div class="masthead__content-wrapper d-flex flex-column <?php echo ($project_masthead ? 'justify-content-top' : 'justify-content-center'); ?>">
        <div class="container <?php echo ($show_breadcrumb ? 'flex-grow-1 d-flex' : ''); echo ($show_breadcrumb && !$project_masthead ? ' align-items-center' : ' align-items-top'); ?>">
            <div class="row w-100">
                <div class="col-12 col-md-10 col-lg-8">
                    <?php if($subtitle != '') { ?>
                        <h3 class="small-title masthead__subtitle color-white"><?php echo $subtitle; ?></h3>
                    <?php } ?>
                    <h1 class="m-0"><?php echo $title; ?></h1>

                    <?php if($content != '') { ?>
                            <div class="row">
                                <div class="col-12 col-lg-10">
                                    <p class="masthead__content color-white"><?php echo $content; ?></p>
                                </div>
                            </div>
                    <?php } ?>

                    <?php if($btn != null) { ?>
                        <div class="masthead__btn">
                            <?php echo format_button($btn, "btn-white btn-white--color-primary", true); ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
        <?php if($show_breadcrumb) {
            include(get_template_directory() . '/inc/partials/breadcrumb.php');
        } ?>
    </div>
</section>
