<?php

$bg = get_field('image_banner_background_image');
$title = get_field('image_banner_title');
$btn = get_field('image_banner_button');
$quote = get_field('image_banner_quote');
$author = get_field('image_banner_quote_author');
$author_logo = get_field('image_banner_quote_author_logo');

?>

    <section class="image-banner">
        <div class="image-banner__bg" style="background-image: url(<?php echo($bg != null ? $bg['url'] : ''); ?>"></div>

        <div class="image-banner__content">
            <div class="container">
                <div class="row">
                    <div class="col-12 col-lg-6 align-self-end">
                        <?php if ($title != '') { ?>
                            <h3 class="small-title color-white m-0">
                                <?php echo $title; ?>
                            </h3>
                        <?php } ?>

                        <?php if ($btn != null) {
                            echo format_button($btn, "btn-white btn-white--color-primary image-banner__btn", true);
                        } ?>
                    </div>

                    <?php if ($quote != '') { ?>
                        <div class="col-12 col-lg-6 align-self-end">
                            <div class="image-banner__quote-holder">
                                <div class="image-banner__quote-holder__quote text-block">
                                    <?php echo $quote; ?>
                                </div>

                                <?php if ($author != '') { ?>
                                    <p class="image-banner__quote-holder__author">
                                        <?php echo $author; ?></p>
                                <?php } ?>

                                <?php if($author_logo != null) { ?>
                                    <div class="image-banner__quote-holder__logo">
                                        <img src="<?php echo $author_logo['url']; ?>"
                                             alt="<?php echo $author_logo['alt']; ?>"
                                             class="img-fluid"/>
                                    </div>
            <?php } ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>

<?php unset($bg, $title, $btn, $quote, $author, $author_logo); ?>