<?php
$title = get_theme_mod('contact_cta_title');
$btn_page_id = get_theme_mod('contact_cta_button_page_id');
$btn = null;

if ($btn_page_id != null) {
    $btn = array(
        'url' => get_the_permalink($btn_page_id),
        'title' => 'Get in touch',
        'target' => '_self'
    );
}

?>

    <section class="contact-cta">
        <div class="container">
            <div class="contact-cta__inner">
                <div class="contact-cta__content">
                    <div class="contact-cta__content__inner">
                        <div class="row">
                            <div class="col-12 col-md-8 col-lg-9">
                                <?php if ($title != '') { ?>
                                    <h2 class="m-0"><?php echo $title; ?></h2>
                                <?php } ?>
                            </div>

                            <?php if ($btn != null) { ?>
                                <div class="col-12 col-md-4 col-lg-3 text-left text-md-right">
                                    <?php echo format_button($btn, "btn-primary contact-cta__btn", true); ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div>

                    <div class="contact-cta__logo-overlay"></div>
                </div>
            </div>
        </div>
    </section>

<?php unset($title, $btn_page_id, $btn); ?>