<?php
$title = get_field('careers_title');
$content = get_field('careers_content');

$args = array(
    'numberposts' => -1,
    'orderby' => 'menu_order',
    'order' => 'ASC',
    'post_type' => 'career',
    'post_status' => 'publish'
);

$careers = get_posts($args);
$career_listing_page = false;
if(is_page_template('template-career-listing.php')) {
    $career_listing_page = true;
}

?>

    <section class="career-listing">
        <div class="container">
            <div class="row large-gutters">
                <?php if ($title != '' || $content != '') { ?>
                    <div class="col-12 col-md-6">
                        <?php if ($title != '') { ?>
                            <h4 class="career-listing__title"><?php echo $title; ?></h4>
                        <?php } ?>

                        <?php if ($content != '') { ?>
                            <div class="text-block">
                                <?php echo $content; ?>
                            </div>
                        <?php } ?>
                    </div>
                <?php } ?>

                <div class="col-12 <?php echo ($career_listing_page ? '' : 'col-md-6'); ?>">
                    <h4 class="career-listing__title">Current opportunities</h4>

                    <div class="career-listing__careers-wrapper">
                        <?php if ($careers != null && !empty($careers)) { ?>
                            <div class="row">
                                <?php foreach ($careers as $career) { ?>
                                    <div class="col-12 career-listing__item <?php echo ($career_listing_page ? 'career-listing__item--reduced-space' : 'col-lg-auto'); ?>">
                                        <?php include(get_template_directory() . '/inc/partials/career-link.php'); ?>
                                    </div>
                                <?php } ?>
                            </div>
                        <?php } else { ?>
                            <div class="text-block">
                                <p>We don't currently have any job vacancies.</p>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php unset($title, $content); ?>