<?php
// Logo
$logo = get_theme_mod('company_logo');

// Contact Details
$telephone = get_theme_mod('contact_telephone');
$contact_email = get_theme_mod('contact_email');
$opening_times = get_theme_mod('opening_times');

// Menu
$menuLocations = get_nav_menu_locations();
if (isset($menuLocations['header'])) {
    $nav_items = wp_get_menu_array('header');
} else {
    $nav_items = null;
}

?>

<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">

    <title><?php wp_title(); ?></title>
    <meta name="description" content="<?php bloginfo('description'); ?>"/>

    <!-- SofiaPro - Typekit -->
    <link rel="stylesheet" href="https://use.typekit.net/krc8wxz.css">

    <!-- Baloo Tammudu 2 - Google Fonts -->
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Baloo+Tammudu+2:wght@500;600&display=swap" rel="stylesheet">

    <script type="text/javascript">
        var ajaxurl = "<?php echo get_site_url(); ?>/wp-admin/admin-ajax.php";
    </script>

    <?php wp_head(); ?>
</head>

<body <?php body_class('site-wrapper'); ?>>

<header class="header">
    <div class="container-fluid">
        <div class="header__inner">
            <div class="row">
                <div class="col-8 col-lg-auto align-self-end">
                    <a href="/" class="header__logo" title="<?php echo get_bloginfo('name'); ?>">
                        <?php if ($logo) { ?>
                            <img src="<?php echo $logo; ?>" alt="<?php echo get_bloginfo('name'); ?>"
                                 class="img-fluid"/>
                        <?php } else {
                            echo get_bloginfo('name');
                        } ?>
                    </a>
                </div>

                <div class="col-4 d-lg-none">
                    <a href="#" class="header__nav-toggle js-navigation-toggle" data-target="#primary-nav">
                    <span class="header__nav-toggle__icon header__nav-toggle__icon--burger">
                        <i class="fal fa-bars"></i>
                    </span>

                        <span class="header__nav-toggle__icon">
                        <i class="fal fa-times"></i>
                    </span>
                    </a>
                </div>

                <div class="col-12 col-lg">
                    <nav class="navigation">
                        <div id="primary-nav" class="navigation__inner">
                            <div class="row">
                                <div class="col-12 order-lg-12">
                                    <?php if ($nav_items != null && !empty($nav_items)) {
                                        $submenu_count = 0;
                                        $submenu_titles = array(
                                            get_theme_mod('services_dropdown_title'),
                                            get_theme_mod('sectors_dropdown_title'),
                                            get_theme_mod('projects_dropdown_title')
                                        ); ?>
                                        <ul class="navigation__main-nav text-left text-lg-right">
                                            <?php foreach ($nav_items as $item) {
                                                $has_submenu = !empty($item['children']);
                                                $sub_id = "submenu-" . $item['ID'];
                                                ?>
                                                <!-- Top Level Nav Item -->
                                                <li class="navigation__main-nav__item <?php echo($has_submenu ? 'navigation__main-nav__item--has-sub js-navigation-submenu-trigger' : ''); ?>"
                                                    data-target="<?php echo '#' . $sub_id; ?>">
                                                    <a href="<?php echo $item['url']; ?>"
                                                       class="navigation__main-nav__link"
                                                       title="<?php echo $item['title']; ?>">
                                                        <?php echo $item['title']; ?>
                                                    </a>

                                                    <?php if ($has_submenu) { ?>
                                                        <!-- Submenu Level 1 -->
                                                        <div id="<?php echo $sub_id; ?>"
                                                             class="navigation__submenu text-left">
                                                            <div class="navigation__submenu__inner">

                                                                <div class="row no-gutters">
                                                                    <div class="col-12 col-lg-5 d-none d-lg-block">
                                                                        <div class="navigation__submenu__section navigation__submenu__section--title">
                                                                            <h2 class="navigation__submenu__title"><?php echo $submenu_titles[$submenu_count]; ?></h2>
                                                                        </div>
                                                                    </div>

                                                                    <div class="col-12 col-lg-7">
                                                                        <div class="navigation__submenu__section">
                                                                            <ul class="list-unstyled m-0 card-columns">
                                                                                <?php foreach ($item['children'] as $sub_item) { ?>
                                                                                    <li class="navigation__main-nav__submenu__item card">
                                                                                        <a href="<?php echo $sub_item['url']; ?>"
                                                                                           class="navigation__main-nav__link navigation__main-nav__link--sub navigation__main-nav__link--large"
                                                                                           title="<?php echo $sub_item['title']; ?>">
                                                                                            <?php echo $sub_item['title']; ?>
                                                                                        </a>

                                                                                        <?php if (!empty($sub_item['children'])) { ?>
                                                                                            <!-- Submenu Level 2 -->
                                                                                            <ul class="list-unstyled m-0">
                                                                                                <?php foreach ($sub_item['children'] as $sub_item_level_2) { ?>
                                                                                                    <li class="navigation__main-nav__submenu__item">
                                                                                                        <a href="<?php echo $sub_item_level_2['url']; ?>"
                                                                                                           class="navigation__main-nav__link navigation__main-nav__link--sub"
                                                                                                           title="<?php echo $sub_item_level_2['title']; ?>">
                                                                                                            <?php echo $sub_item_level_2['title']; ?>
                                                                                                        </a>
                                                                                                    </li>
                                                                                                <?php } ?>
                                                                                            </ul>
                                                                                        <?php } ?>
                                                                                    </li>
                                                                                <?php } ?>
                                                                            </ul>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    <?php $submenu_count++;
                                                    } ?>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                    <?php } ?>
                                </div>

                                <div class="col-12 order-lg-1">
                                    <?php if ($telephone != '' || $contact_email != '' || $opening_times != '') { ?>
                                        <ul class="navigation__contact-links list-unstyled text-left text-lg-right">
                                            <?php if ($telephone != '') { ?>
                                                <li class="navigation__contact-links__item">
                                                    <a href="tel:<?php echo $telephone; ?>"
                                                       class="contact-link navigation__contact-links__link">
                                                    <span class="contact-link__icon">
                                                        <i class="fas fa-phone"></i>
                                                    </span>
                                                        <?php echo $telephone; ?>
                                                    </a>
                                                </li>
                                            <?php } ?>

                                            <?php if ($contact_email != '') { ?>
                                                <li class="navigation__contact-links__item">
                                                    <a href="mailto:<?php echo $contact_email; ?>"
                                                       class="contact-link navigation__contact-links__link">
                                                    <span class="contact-link__icon">
                                                        <i class="fas fa-envelope"></i>
                                                    </span>
                                                        <?php echo $contact_email; ?>
                                                    </a>
                                                </li>
                                            <?php } ?>

                                            <?php if ($opening_times != '') { ?>
                                                <li class="navigation__contact-links__item">
                                                    <div class="contact-link navigation__contact-links__link">
                                                    <span class="contact-link__icon">
                                                        <i class="fas fa-clock"></i>
                                                    </span>
                                                        <?php echo $opening_times; ?>
                                                    </div>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</header>

<main class="page-body">