<?php

// About
$about_title = get_field('about_title');
$about_subtitle = get_field('about_subtitle');
$about_content = get_field('about_content');
$about_btn = get_field('about_button');
$about_details = get_field('about_details');

// Services
$services_title = get_field('services_title');
$services_subtitle = get_field('services_subtitle');
$services = get_field('services');

get_header();

render_masthead('homepage_masthead');

?>

    <section class="homepage__about">
        <div class="container">
            <?php if ($about_title != '') { ?>
                <div class="row">
                    <div class="col-12">
                        <h2 class="small-title small-title--accented"><?php echo $about_title; ?></h2>
                    </div>
                </div>
            <?php } ?>
            <div class="row">
                <?php if ($about_subtitle != '') { ?>
                    <div class="col-12 col-md-6 col-lg-7">
                        <h3 class="h2 mt-0"><?php echo $about_subtitle; ?></h3>
                    </div>
                <?php } ?>

                <div class="col-12 col-md-6 col-lg-5">
                    <?php if ($about_content != '') { ?>
                        <div class="text-block">
                            <?php echo $about_content; ?>
                        </div>
                    <?php } ?>

                    <?php if ($about_btn != null) {
                        echo format_button($about_btn, "btn-white homepage__about__btn", true);
                    } ?>
                </div>
            </div>

            <?php if ($about_details != null) { ?>
                <div class="homepage__about__details">
                    <div class="row">
                        <?php foreach ($about_details as $detail) { ?>
                            <div class="col-12 col-md-4">
                                <div class="about-detail">
                                    <div class="about-detail__icon">
                                        <i class="fal fa-<?php echo $detail['icon']; ?>"></i>
                                    </div>

                                    <?php if ($detail['title'] != '') { ?>
                                        <h4 class="small-title about-detail__title">
                                            <?php echo $detail['title']; ?></h4>
                                    <?php } ?>

                                    <?php if ($detail['description'] != '') { ?>
                                        <div class="about-detail__description text-block">
                                            <?php echo $detail['description']; ?>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            <?php } ?>
        </div>
    </section>

<?php if ($services != null) { ?>
    <section class="homepage__services">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-10 col-lg-7">
                    <?php if ($services_title != '') { ?>
                        <h2 class="small-title small-title--accented small-title--orange"><?php echo $services_title; ?></h2>
                    <?php } ?>

                    <?php if ($services_subtitle != '') { ?>
                        <h3 class="h2 mt-0"><?php echo $services_subtitle; ?></h3>
                    <?php } ?>
                </div>
            </div>

            <div class="homepage__services__grid">
                <div class="row">
                    <?php foreach ($services as $service) { ?>
                        <div class="col-12 col-sm-6 col-md-4 homepage__services__grid__item">
                            <?php include(get_template_directory() . '/inc/partials/service-card.php'); ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </section>
<?php } ?>

<?php

include(get_template_directory() . '/inc/blocks/image-banner.php');
include(get_template_directory() . '/inc/blocks/featured-footer.php');

get_footer();
