<?php
// Logo
$logo = get_theme_mod('company_logo');

// Details
$company_name = get_theme_mod('company_name');
$reg_number = get_theme_mod('company_reg');
$areas = get_theme_mod('covering_areas');
$office = get_theme_mod('registered_office');

// Menus
$menuLocations = get_nav_menu_locations();
if (isset($menuLocations['footer'])) {
    $footer_nav = wp_get_nav_menu_items($menuLocations['footer']);
} else {
    $footer_nav = null;
}

if (isset($menuLocations['footer_services'])) {
    $footer_services_nav = wp_get_nav_menu_items($menuLocations['footer_services']);
} else {
    $footer_services_nav = null;
}

if (isset($menuLocations['legal'])) {
    $legal_nav = wp_get_nav_menu_items($menuLocations['legal']);
} else {
    $legal_nav = null;
}

$args = array(
    'numberposts' => 4,
    'orderby' => 'date',
    'order' => 'DESC',
    'post_type' => 'project',
    'post_status' => 'publish',
);

$projects = get_posts($args);

// Accreditations
$accreditations = get_field('option_accreditations_logos', 'option');

?>

</main>

<footer class="footer">
    <?php if ($accreditations != null && !empty($accreditations)) { ?>
        <div class="footer__accreditations">
            <div class="container">
                <div class="row js-accreditation-slider">
                    <?php foreach ($accreditations as $cred_logo) { ?>
                        <div class="col">
                            <div class="footer__accreditations__logo">
                                <div class="footer__accreditations__logo__inner"
                                     style="background-image: url(<?php echo $cred_logo['url']; ?>);"></div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    <?php } ?>

    <div class="footer__main">
        <div class="container">
            <div class="footer__main__inner">
                <div class="row">
                    <div class="col-12 col-lg-4">
                        <?php if ($logo != null) { ?>
                            <div class="footer__logo">
                                <img src="<?php echo $logo; ?>" alt="<?php echo get_bloginfo('name'); ?>"
                                     class="img-fluid"/>
                            </div>
                        <?php } ?>

                        <?php if ($reg_number != '' || $areas != '') { ?>
                            <div class="footer__company-info">
                                <?php if ($areas != '') {
                                    echo '<p class="m-0">Covering ' . $areas . '</p>';
                                }

                                if ($reg_number != '') {
                                    echo '<p class="m-0">Company reg: ' . $reg_number . '</p>';
                                } ?>
                            </div>
                        <?php } ?>
                    </div>

                    <div class="col-12 col-lg-8">
                        <div class="row">
                            <?php if ($footer_services_nav != null && !empty($footer_services_nav)) { ?>
                                <div class="col-12 col-md-4 d-none d-md-block">
                                    <div class="footer__nav-wrapper">
                                        <h5 class="footer__nav-title small-title">Services</h5>
                                        <ul class="footer__nav list-unstyled">
                                            <?php foreach ($footer_services_nav as $item) { ?>
                                                <li class="footer__nav__item">
                                                    <a href="<?php echo $item->url; ?>"
                                                       class="footer__nav__link"
                                                       title="<?php echo $item->title; ?>">
                                                        <?php echo $item->title; ?>
                                                    </a>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php } ?>

                            <?php if ($footer_nav != null && !empty($footer_nav)) { ?>
                                <div class="col-12 col-md-4">
                                    <div class="footer__nav-wrapper">
                                        <h5 class="footer__nav-title small-title">Website</h5>
                                        <ul class="footer__nav list-unstyled">
                                            <?php foreach ($footer_nav as $item) { ?>
                                                <li class="footer__nav__item">
                                                    <a href="<?php echo $item->url; ?>"
                                                       class="footer__nav__link"
                                                       title="<?php echo $item->title; ?>">
                                                        <?php echo $item->title; ?>
                                                    </a>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php } ?>

                            <?php if ($projects != null && !empty($projects)) { ?>
                                <div class="col-12 col-md-4 d-none d-md-block">
                                    <div class="footer__nav-wrapper">
                                        <h5 class="footer__nav-title small-title">Projects</h5>
                                        <ul class="footer__nav list-unstyled">
                                            <?php foreach ($projects as $project) { ?>
                                                <li class="footer__nav__item">
                                                    <a href="<?php echo get_the_permalink($project->ID); ?>"
                                                       class="footer__nav__link"
                                                       title="<?php echo $project->post_title; ?>">
                                                        <?php echo $project->post_title; ?>
                                                    </a>
                                                </li>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="footer__legal">
        <div class="container">
            <div class="row">
                <div class="col-12 col-md-8 col-lg-auto">
                    <?php if ($company_name != '') { ?>
                        <p>&copy; <?php echo $company_name; ?></p>
                    <?php } ?>

                    <?php if ($office != '') { ?>
                        <p>Registered Office: <?php echo $office; ?></p>
                    <?php } ?>
                </div>

                <?php if ($legal_nav != null && !empty($legal_nav)) { ?>
                    <div class="col-12 col-md-4 col-lg">
                        <ul class="footer__legal-nav list-unstyled text-md-right">
                            <?php foreach ($legal_nav as $item) { ?>
                                <li class="footer__legal-nav__item">
                                    <a href="<?php echo $item->url; ?>"
                                       class="footer__legal-nav__link"
                                       title="<?php echo $item->title; ?>">
                                        <?php echo $item->title; ?>
                                    </a>
                                </li>
                            <?php } ?>
                        </ul>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</footer>

<?php wp_footer(); ?>
</body>
</html>