jQuery(function($) {
    let $map = $('.js-map');

    // Calculate Scroll Direction
    let lastScrollTop = 0;
    let scrollDown = false;
    let scrollUp = false;

    $(window).scroll(function(){
        var st = $(this).scrollTop();
        if (st > lastScrollTop){
            scrollDown = true;
            scrollUp = false;
        } else {
            scrollUp = true;
            scrollDown = false;
        }
        lastScrollTop = st;
    });

    // Nav
    let desktopNavBreakpoint = 992;

    // - Mobile Toggle
    $('.js-navigation-toggle').click(function(e) {
       e.preventDefault();
       let activeClass = 'open';
       let target = $(this).data('target');

       if($(this).hasClass(activeClass)) {
           // Close Menu
           $(target).slideUp();
            $(this).removeClass(activeClass);
       } else {
           // Open Menu
           $(target).slideDown();
           $(this).addClass(activeClass);
       }

       $(this).blur();
    });

    // - Mobile Reveal Submenu
    let $submenuTrigger = $('.js-navigation-submenu-trigger');
    let subOpenClass = 'navigation__main-nav__item--has-sub--open';
    $submenuTrigger.click(function(e) {
        if ($(window).width() < desktopNavBreakpoint) {
            let target = $(this).data('target');

            if ($(this).hasClass(subOpenClass)) {
                // Close Sub
                $(target).slideUp();
                $(this).removeClass(subOpenClass);
            } else {
                // Open Sub
                $(target).slideDown();
                $(this).addClass(subOpenClass);
            }
        }
    });

    // - Desktop Reveal Submenu
    if ($(window).width() >= desktopNavBreakpoint) {
        $submenuTrigger.hover(
            function() {
                let target = $(this).data('target');
                $(this).addClass(subOpenClass);
                $(target).stop().fadeIn(300);
            }, function() {
                let target = $(this).data('target');
                $(this).removeClass(subOpenClass);
                $(target).stop().fadeOut(300);
            }
        );
    }

    // Accreditation Slider
    let $accreditationSlider = $('.js-accreditation-slider');
    if($accreditationSlider.length > 0) {
        $accreditationSlider.slick({
            infinite: true,
            speed: 300,
            slidesToShow: 6,
            slidesToScroll: 6,
            arrows: false,
            autoplay: true,
            responsive: [
                {
                    breakpoint: 100000,
                    settings: "unslick"
                },
                {
                    breakpoint: 991,
                    settings: {
                        slidesToShow: 4,
                        slidesToScroll: 4
                    }
                },
                {
                    breakpoint: 767,
                    settings: {
                        slidesToShow: 2,
                        slidesToScroll: 2
                    }
                },
                {
                    breakpoint: 575,
                    settings: {
                        slidesToShow: 1,
                        slidesToScroll: 1
                    }
                }
            ]
        });
    }

    // Form Collapse Label
    let collapseLabelWrapperClass = '.js-collapse-label';
    let collapseLabelFocusClass = 'filled';

    function focusLabelOut($input) {
        let val = $input.val();

        if(val == '') {
            let wrapper = $input.closest(collapseLabelWrapperClass);
            $(wrapper).removeClass(collapseLabelFocusClass);
        }
    }

    function focusLabelIn($input) {
        let wrapper = $input.closest(collapseLabelWrapperClass);
        $(wrapper).addClass(collapseLabelFocusClass);
    }

    if($(collapseLabelWrapperClass).length > 0) {
        $(collapseLabelWrapperClass + ' input').each(function () {
            focusLabelOut($(this));
        });
    }

    $(collapseLabelWrapperClass + ' input').focusin(function() {
        focusLabelIn($(this));
    });

    $(collapseLabelWrapperClass + ' textarea').focusin(function() {
        focusLabelIn($(this));
    });

    $(collapseLabelWrapperClass + ' input').focusout(function() {
        focusLabelOut($(this));
    });

    $(collapseLabelWrapperClass + ' textarea').focusout(function() {
        focusLabelOut($(this));
    });

    // Map
    function initMap() {
        let markers = [];
        let styles = [
            {
                "featureType": "water",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#e9e9e9"
                    },
                    {
                        "lightness": 17
                    }
                ]
            },
            {
                "featureType": "landscape",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#f5f5f5"
                    },
                    {
                        "lightness": 20
                    }
                ]
            },
            {
                "featureType": "road.highway",
                "elementType": "geometry.fill",
                "stylers": [
                    {
                        "color": "#ffffff"
                    },
                    {
                        "lightness": 17
                    }
                ]
            },
            {
                "featureType": "road.highway",
                "elementType": "geometry.stroke",
                "stylers": [
                    {
                        "color": "#ffffff"
                    },
                    {
                        "lightness": 29
                    },
                    {
                        "weight": 0.2
                    }
                ]
            },
            {
                "featureType": "road.arterial",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#ffffff"
                    },
                    {
                        "lightness": 18
                    }
                ]
            },
            {
                "featureType": "road.local",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#ffffff"
                    },
                    {
                        "lightness": 16
                    }
                ]
            },
            {
                "featureType": "poi",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#f5f5f5"
                    },
                    {
                        "lightness": 21
                    }
                ]
            },
            {
                "featureType": "poi.park",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#dedede"
                    },
                    {
                        "lightness": 21
                    }
                ]
            },
            {
                "elementType": "labels.text.stroke",
                "stylers": [
                    {
                        "visibility": "on"
                    },
                    {
                        "color": "#ffffff"
                    },
                    {
                        "lightness": 16
                    }
                ]
            },
            {
                "elementType": "labels.text.fill",
                "stylers": [
                    {
                        "saturation": 36
                    },
                    {
                        "color": "#333333"
                    },
                    {
                        "lightness": 40
                    }
                ]
            },
            {
                "elementType": "labels.icon",
                "stylers": [
                    {
                        "visibility": "off"
                    }
                ]
            },
            {
                "featureType": "transit",
                "elementType": "geometry",
                "stylers": [
                    {
                        "color": "#f2f2f2"
                    },
                    {
                        "lightness": 19
                    }
                ]
            },
            {
                "featureType": "administrative",
                "elementType": "geometry.fill",
                "stylers": [
                    {
                        "color": "#fefefe"
                    },
                    {
                        "lightness": 20
                    }
                ]
            },
            {
                "featureType": "administrative",
                "elementType": "geometry.stroke",
                "stylers": [
                    {
                        "color": "#fefefe"
                    },
                    {
                        "lightness": 17
                    },
                    {
                        "weight": 1.2
                    }
                ]
            }
        ];

        $map.each(function () {
            let currMap = $(this)[0];

            let mapData = $(currMap).data("locations");
            let mapMarker = $(currMap).data('marker');

            let mapOptions = {
                zoom: 10,
                scrollwheel: false,
                center: new google.maps.LatLng(mapData[0].latitude, mapData[0].longitude),
                zoomControlOptions: {
                    position: google.maps.ControlPosition.RIGHT_CENTER
                },
                streetViewControl: true,
                streetViewControlOptions: {
                    position: google.maps.ControlPosition.RIGHT_CENTER
                },
                styles: styles
            };

            // Create the Google Map using our element and options defined above
            let map = new google.maps.Map(currMap, mapOptions);

            var markerCount = 0;
            $.each(mapData, function (index, item) {
                var marker = new google.maps.Marker({
                    position: new google.maps.LatLng(item.latitude, item.longitude),
                    map: map,
                    icon: {
                        url: mapMarker,
                        scaledSize: new google.maps.Size(25, 42)
                    },
                    animation: google.maps.Animation.DROP
                });

                marker.set("officeId", item.id);
                markers.push(marker);

                markerCount++;
            });
        });
    }

    if($map.length > 0) {
        google.maps.event.addDomListener(window, 'load', initMap);
    }

    // Sector Gallery
    let $sectorGallery = $('.js-sector-gallery');
    if($sectorGallery.length > 0) {
        let dotsNav = $sectorGallery.siblings('.js-sector-gallery-dots-nav');
        let arrowNav = $sectorGallery.siblings('.js-sector-gallery-arrow-nav');

        $sectorGallery.slick({
            autoplay: true,
            appendDots: $(dotsNav),
            appendArrows: $(arrowNav),
            autoplaySpeed: 4000,
            arrows: true,
            dots: true,
            infinite: true,
            slidesToShow: 1,
            centerMode: true,
            variableWidth: true,
            prevArrow: '<button type="button" class="slick-prev"><i class="fal fa-chevron-left"></i></button>',
            nextArrow: '<button type="button" class="slick-next"><i class="fal fa-chevron-right"></i></button>'
        });
    }

    // Filters
    function filterListing() {
        let $filterForm = $('.js-filter-form');
        let url = $filterForm.data('listing-url') + "?";

        let sectorFilters = $('.js-sector-filter:checked');
        let serviceFilters = $('.js-service-filter:checked');

        if(sectorFilters.length > 0) {
            url += "sectors=";

            sectorFilters.each(function() {
                url += $(this).val() + ",";
            });

            url = url.substring(0,url.length - 1);

            if(serviceFilters.length > 0) {
                url += "&";
            }
        }

        if(serviceFilters.length > 0) {
            url += "services=";

            serviceFilters.each(function() {
                url += $(this).val() + ",";
            });

            url = url.substring(0,url.length - 1);
        }

        window.location.href = url;
    }

    let $filters = $('.js-filter');
    $filters.change(function(e) {
        filterListing();
    });

    $('.js-filter-reset').click(function(e) {
       e.preventDefault();
       $filters.prop("checked", false);
       filterListing();
    });

    // Sticky Form
    let $stickyFormWrapper = $('.js-contact-form-wrapper');
    let $stickyForm = $('.js-sidebar-form');

    if($stickyForm.length > 0) {
        let offset = 20;
        let startPos = $stickyForm.offset().top;
        let maxScroll = $stickyFormWrapper.outerHeight() + $stickyFormWrapper.offset().top;
        let affixClass = 'affixed';

        function stickSidebar() {
            // Stick
            let formWidth = $stickyForm.width();
            $stickyForm.width(formWidth);
            $stickyForm.addClass(affixClass);
            $stickyForm.css('top', 0 + offset);
            $stickyForm.css('left', 'auto');
            $stickyForm.css('bottom', 'auto');
            hitLimit = false;
        }

        $(window).on('scroll', function (event) {
            if ($(window).width() >= 992) {
                var currScroll = $(window).scrollTop();
                let hitLimit = false;

                if (currScroll > (startPos - offset)) {
                    if (scrollUp) {
                        if ((currScroll + $stickyForm.outerHeight()) < maxScroll) {
                            stickSidebar();
                        }
                    }
                    if (scrollDown) {
                        if (hitLimit == false) {
                            if ((currScroll + $stickyForm.outerHeight()) >= maxScroll) {
                                // Sidebar has reach the page limit so let's absolute position
                                $stickyForm.removeClass(affixClass);
                                $stickyForm.css('position', 'absolute');
                                $stickyForm.css('left', 22);
                                $stickyForm.css('top', maxScroll - $stickyForm.outerHeight() - startPos);
                                hitLimit = true;
                            } else {
                                stickSidebar();
                            }
                        }
                    }
                } else {
                    // Unstick
                    $stickyForm.removeClass(affixClass);
                    $stickyForm.css('position', 'relative');
                    $stickyForm.css('left', 'auto');
                    $stickyForm.css('top', 'auto');
                    $stickyForm.css('bottom', 'auto');
                }
            }
        });
    }

    // Smooth Scroll
    $('a[href*="#"]')
        .not('[href="#"]')
        .not('[href="#0"]')
        .not('.js-no-scroll')
        .click(function(event) {
            if (
                location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '')
                &&
                location.hostname == this.hostname
            ) {
                var target = $(this.hash);
                target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
                if (target.length) {
                    event.preventDefault();
                    $('html, body').animate({
                        scrollTop: target.offset().top
                    }, 1000, function() {
                        var $target = $(target);
                        $target.focus();
                        if ($target.is(":focus")) {
                            return false;
                        } else {
                            $target.attr('tabindex','-1');
                            $target.focus();
                        };
                    });
                }
            }
        });
});